#ifndef _H_CDiskMapWindow
#define _H_CDiskMapWindow

#include "GenStructs.h"
#include "COffscreen.h"
#include "ProStructs.h"
#include "CWindow.h"

class	CDisk;

//	button, radio, map area etc.
typedef enum {
	DiskMap_SubPane_NONE, 
	
	DiskMap_SubPane_MAP, 
	DiskMap_SubPane_VIEW_POP, 
	DiskMap_SubPane_SECTOR_ORDER_POP, 
	DiskMap_SubPane_PATHNAME, 
	DiskMap_SubPane_FILE_TYPE, 
	DiskMap_SubPane_CLICKED_BLOCK, 
	
	//	must match Gen_AllocType
	DiskMap_SubPane_LEGEND, 
	DiskMap_SubPane_LEGEND_FILE,
	DiskMap_SubPane_LEGEND_FILE_BAS,
	DiskMap_SubPane_LEGEND_FILE_BIN,
	DiskMap_SubPane_LEGEND_FILE_TXT,
	DiskMap_SubPane_LEGEND_EXTENTS,
	DiskMap_SubPane_LEGEND_MYSTERY,
	DiskMap_SubPane_LEGEND_MULTI,	//	Gen_AllocNodeRec
	DiskMap_SubPane_LEGEND_DIRECTORY,
	DiskMap_SubPane_LEGEND_BOOT,
	DiskMap_SubPane_LEGEND_V_BITMAP,

	DiskMap_SubPane_NUMTYPES, 
	
	DiskMap_SubPane_LEGEND_FILE_HILIGHT_0 = DiskMap_SubPane_NUMTYPES, 
	DiskMap_SubPane_LEGEND_FILE_HILIGHT_1, 
	DiskMap_SubPane_LEGEND_FILE_HILIGHT_2, 
	
	DiskMap_SubPane_LEGEND_BLOCK_HILIGHT
} DiskMap_SubPaneType;

#define	DiskMap_SubPane_LEGEND_FILE_HILIGHT_MAX		(DiskMap_SubPaneType)(DiskMap_SubPane_LEGEND_BLOCK_HILIGHT - DiskMap_SubPane_LEGEND_FILE_HILIGHT_0 - 1)

ulong	CountNodeRecH(Gen_AllocNodeRec **nodeRecH);

#define		kMapWindowPopHeight			28
#define		kMapWindowHeaderHeight		112
#define		kLegendSecondColOffset		110
#define		kLegendHeight				59

#define		DMW_POP_HEIGHT		\
	((i_sectorPop || i_viewAsPop) ? kMapWindowPopHeight : 0)

#define		DMW_HEADER_DIVIDER	\
	(kMapWindowHeaderHeight + DMW_POP_HEIGHT)

extern	RgnHandle		gRgn1;

/***********************************************************/
class CDiskMapWindow : public CWindow {

	public:		Boolean	IDiskMapWindow(
		CDisk	*diskP);

	virtual		void	Dispose(void);

	virtual		void		Move(EventRecord *event);
	virtual		void		Size(EventRecord *event);
	virtual		void		Zoom(EventRecord *event, short direction);
	
	Boolean		UpdateViewAs(Boolean flushB = FALSE);

	virtual	Rect	GetSizeRect(void);

	void	DoClick_Map(void);

	void	DoClick_Header(
		Point					hitPoint, 
		DiskMap_SubPaneType		subPane, 
		Rect					*theRect);

	char		*LegendStr_TotalSectors(CEntry *entryP, char *bufZ);
	char		*LegendStr(DiskMap_SubPaneType curLeg, char *bufP);
	virtual		void	DoKeyDown(EventRecord *event);
	virtual		void	DoClick(EventRecord *event);
	virtual		void	InvalWindow(WindowRectType windowRect);

	CEntry	*GetIndMultiEntry(ushort indexS);

	void	Draw_CurEntryRgn(void);
	void	Draw_CurEntryRgn_Single(
		CEntry		*entryP, 
		ushort		indexS);
		
	void	Draw_CurSectorRect(void);
	void	Draw_CurSectorRect_Single(
		CEntry		*entryP);

	void	DoClick_ResetToZero(
		ushort		*prevMapRowS0, 
		ushort		*prevMapColS0, 
		Rect		*prevHitRectP, 
		RgnHandle	prevRgnH);
		
	void				HiliteEntry(CEntry	*entryP);
	void				Draw_PathAndBlock(void);
	void				Draw_Header(void);
	void				Draw_Map(Boolean skip_blocksB = FALSE);
	virtual		void	Draw(void);

	virtual		void	Idle(void);
	virtual		Boolean	DoCommand(long command);

	Pattern		*GetSectorPattern(Gen_AllocType allocType);
	void		ThemeNormal(void);
	void		SetSectorTheme(Gen_AllocType allocType);
	RGBColor	GetSectorColor(Gen_AllocType sectorType);

	void		PaintSectorRect(
		Gen_AllocType	sectorType, 
		Rect			*theRect, 
		Boolean			fill_noneB = FALSE);

	virtual		void	UpdateMenus(void);

	Rect		GetSubPaneRect(DiskMap_SubPaneType wrType);

	Boolean		HitTest(
		Point					thePoint, 
		WindowRectType			*pane, 
		DiskMap_SubPaneType		*subPane,
		ushort					*mapRowS, 
		ushort					*mapColS, 
		Rect					*hitRect);

	virtual		Rect	GetWindowRect(WindowRectType wrType);
	
	virtual		void	Show(Boolean show);
	
	static	void	CB_S_DiskMap_Offs(
		OffscreenCBType cbType, 
		OffscreenCBData	*cbData, 
		void			*cbRefcon);

	virtual	void	CB_DiskMap_Offs(
		OffscreenCBType cbType, 
		OffscreenCBData	*cbData);
	
	
	void	GetEntryRgnR(Gen_AllocNodeRec *sectorP, RgnHandle theRgn);
	void	GetEntryRgnSingle(CEntry *entryP, RgnHandle theRgn);

	Boolean		Refresh(
		CEntry	*entryP = NULL, 
		Boolean	addingB = FALSE, 
		Boolean flushB	= FALSE);
	
	Gen_EntryAlloc	*GetEntryAlloc(CEntry *entryP);
	Gen_EntryAlloc	*DupEntryAllocEmpty(Gen_EntryAlloc *allocP);

	/****************************/
	void		SetRowColumnSize(void);

	Rect		GetRowColumnRect(
		short rowS, short columnS);
		
	Rect		GetTrackSectorRect(
		Boolean skewedB, short trackS, short sectorS);

	Rect		GetRowColumnBlockRect(
		short rowS, short columnS);

	Rect		GetBlockRect(
		Pro_BlockNum blockS);

	Pro_BlockNum		RowColumnToBlock(
		short rowS, short columnS);
		
	/******************************************/
	private:
	COffscreen	*i_offscreenP;
	CDisk		*i_diskP;

	ulong				i_timeStamp;
	
	Gen_AllocSizeType	i_allocSize;
	Gen_AllocMap		*i_allocMapP;
	
	Gen_DiskBitUnion	i_diskBitMap;
	
	ControlRef	i_viewAsPop;
	ControlRef	i_sectorPop;
		
	short		i_rowSizeS;
	short		i_maxRowS;
	short		i_colSizeS;
	short		i_maxColS;
	Rect		i_marginsR;
	short		i_depthS;
	
	FSType		i_sectorOrder;
	
	Gen_AllocNodeRec	i_hiliteSector;
	Gen_AllocNodeRec	*i_sectorP;
	ushort				i_hitBlockS, i_hitTrackS, i_hitSectorS;
	Boolean				i_draw_rectB;
	
	typedef CWindow	_inherited;
};

#endif